function Menu(windowed)
{
	this.windowed = windowed; // Draw window?
	this.items = new Array();
	this.selection = 0;
	this.top_selection = 0;
	this.opened = false;
	this.tw = 0;
	this.th = 0;
	this.sound = undefined;
	this.sound_start = 0;
}

Menu.prototype.addItem = function(name, link, color)
{
	if (link == undefined)
	{
		link = Exit;
	}
	if (color == undefined)
	{
		color = Colors.Normal;
	}
	var item = new Object();
	item.name = name;
	item.link = link;
	item.color = color;
	this.items[this.items.length] = item;
}

Menu.prototype.open = function(x, y, w, h)
{
	Game.menuopen = true;
	this.tw += w / 2;
	this.th += h /2;
	if (this.tw == w && this.th == h)
	{
		this.opened = true;
	}
	if (this.opened == false)
	{
		window.drawWindow(x, y, this.tw, this.th, true, "MENU");
	}
}

Menu.prototype.execute = function(x, y, w, h)
{
	if (this.sound != undefined)
	{
		this.sound.stop();
		this.sound = undefined;
	}
	h = (h - 1) * 10 + 6;
	if (this.opened == false && this.windowed == true)
	{
		this.open(x, y + 4, w, h);
	}
	if (this.opened == false && this.windowed == false)
	{
		this.opened = true;
	}
	// After opening the window (if you had too), draw the menu items and cursors
	if (this.opened == true )
	{
		if (this.windowed == true)
		{
			window.drawWindow(x, y + 4, w, h, true, "MENU");
		}
		for (var i = 0; i < this.items.length; i ++)
		{
			font.drawText(x + 5, y + i * 10 + 6, this.items[i].name, "left", this.items[i].color);
		}
		DrawCursor(x + 5, y + this.selection * 10 + 6);
		// Put arrows and such here
		if (AreKeysLeft())
		{
			switch (GetKey())
			{
				case KEY_DOWN:
				{
					this.sound = Game.menu_move;
					this.sound.play(false);
					if (this.selection < this.items.length - 1)
					{
						this.selection ++;
						if (this.selection >= this.top_selection + h / 10)
						{
							this.top_selection ++;
						}
					}
					break;
				}
				case KEY_UP:
				{
					this.sound = Game.menu_move;
					this.sound.play(false);
					if (this.selection > 0)
					{
						this.selection --;
						if (this.selection < this.top_selection)
						{
							this.top_selection --;
						}
					}
					break;
				}
				case Game.accept:
				{
					this.sound = Game.menu_accept;
					this.sound.play(false);
					Game.menuopen = false;
					this.items[this.selection].link(this.selection);
					break;
				}
				case Game.cancel:
				{
					this.sound = Game.menu_cancel;
					this.sound.play(false);
					Game.menuopen = false;
					break;
				}
			}
		}
	}
}

Menu.prototype.moveDown = function()
{
	if (this.selection < this.items.length - 1)
	{
		this.selection ++;
		if (this.selection >= this.top_selection + h / 10)
		{
			this.top_selection ++;
		}
	}
}

Menu.prototype.moveUp = function()
{
	if (this.selection > 0)
	{
		this.selection --;
		if (this.selection < this.top_selection)
		{
			this.top_selection --;
		}
	}
}

Menu.prototype.moveAccept = function()
{
	this.items[this.selection].link();
}

Menu.prototype.moveCancel = function()
{

}

Menu.prototype.executeAlone = function(x, y, w, h)
{
	Game.menuopen = true;
	var background = GrabImage(0, 0, 320, 240);
	while (Game.menuopen)
	{
		background.blit(0, 0);
		this.execute(x, y, w, h);
		FlipScreen();
	}
}

Menu.prototype.executeMap = function(x, y, w, h)
{
	Game.currentmenu = this;
	Game.currentmenu.x = x;
	Game.currentmenu.y = y;
	Game.currentmenu.w = w;
	Game.currentmenu.h = h;
}